/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.constraint.ADQLConstraint;
import adql.query.operand.ADQLColumn;
import java.util.NoSuchElementException;

public class IsNull
implements ADQLConstraint {
    private ADQLColumn column;
    private boolean isNotNull = false;

    public IsNull(ADQLColumn aDQLColumn) throws NullPointerException {
        this(aDQLColumn, false);
    }

    public IsNull(ADQLColumn aDQLColumn, boolean bl) throws NullPointerException {
        this.setColumn(aDQLColumn);
        this.isNotNull = bl;
    }

    public IsNull(IsNull isNull) throws Exception {
        this.column = (ADQLColumn)isNull.column.getCopy();
        this.isNotNull = isNull.isNotNull;
    }

    public final ADQLColumn getColumn() {
        return this.column;
    }

    public final void setColumn(ADQLColumn aDQLColumn) throws NullPointerException {
        if (aDQLColumn == null) {
            throw new NullPointerException("Impossible to compare nothing to NULL: no column has been given to build a IsNull constraint !");
        }
        this.column = aDQLColumn;
    }

    public final boolean isNotNull() {
        return this.isNotNull;
    }

    public final void setNotNull(boolean bl) {
        this.isNotNull = bl;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new IsNull(this);
    }

    @Override
    public String getName() {
        return "IS" + (this.isNotNull ? " NOT " : " ") + "NULL";
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean columnGot;
            {
                this.columnGot = IsNull.this.column == null;
            }

            @Override
            public ADQLObject next() {
                if (this.columnGot) {
                    throw new NoSuchElementException();
                }
                this.columnGot = true;
                return IsNull.this.column;
            }

            @Override
            public boolean hasNext() {
                return !this.columnGot;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (!this.columnGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else if (aDQLObject instanceof ADQLColumn) {
                    IsNull.this.column = (ADQLColumn)aDQLObject;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace a column (" + IsNull.this.column.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") in a IsNull constraint (" + IsNull.this.toADQL() + ") !");
                }
            }

            @Override
            public void remove() {
                if (!this.columnGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the only column (" + IsNull.this.column.toADQL() + ") of a constraint IsNull (" + IsNull.this.toADQL() + ") !");
            }
        };
    }

    @Override
    public String toADQL() {
        return this.column.toADQL() + " " + this.getName();
    }
}

